package org.msh.tb.entities;

import org.hibernate.validator.NotNull;
import org.msh.tb.entities.enums.TbFormField;

import javax.persistence.*;
import java.util.Date;

/**
 * Created by Mauricio on 04/03/2017.
 */
@Entity
@Table(name="tbformvalue")
public class TbFormValue {

    @Id
    @GeneratedValue(strategy= GenerationType.AUTO)
    private Integer id;

    private TbFormField field;

    @Temporal(TemporalType.DATE)
    private Date referenceDate;

    private Integer value;

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="UNIT_ID")
    @NotNull
    private Tbunit tbunit;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public TbFormField getField() {
        return field;
    }

    public void setField(TbFormField field) {
        this.field = field;
    }

    public Date getReferenceDate() {
        return referenceDate;
    }

    public void setReferenceDate(Date referenceDate) {
        this.referenceDate = referenceDate;
    }

    public Integer getValue() {
        return value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public Tbunit getTbunit() {
        return tbunit;
    }

    public void setTbunit(Tbunit tbunit) {
        this.tbunit = tbunit;
    }
}
